<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    /** @use HasFactory<\Database\Factories\BookingFactory> */
    use HasFactory;

    protected $fillable = [
        'package_id',
        'user_id',
        'agent_id',
        'address_id',
        'trnx_id',
        'booking_date',
        'amount',
        'amount_paid',
        'payment_method',
        'payment_id',
        'adult',
        'child',
        'infant',
        'peoples',
        'payment_status',
        'status',
    ];

    public function package()
    {
        return $this->belongsTo(Package::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function agent()
    {
        return $this->belongsTo(User::class);
    }

    public function address()
    {
        return $this->belongsTo(Address::class);
    }

    public function travelers()
    {
        return $this->hasMany(Traveller::class);
    }
}
